<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\WarehousingAndDistribution;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Amazon Warehousing and Distribution.
 *
 * The Selling Partner API for Amazon Warehousing and Distribution (AWD) provides programmatic access to information about AWD shipments and inventory.
 *
 * The version of the OpenAPI document: 2024-05-09
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PrepDetails implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'PrepDetails';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'label_owner' => '\AmazonPHP\SellingPartner\Model\WarehousingAndDistribution\LabelOwner',
        'prep_category' => 'string',
        'prep_instructions' => '\AmazonPHP\SellingPartner\Model\WarehousingAndDistribution\PrepInstruction[]',
        'prep_owner' => '\AmazonPHP\SellingPartner\Model\WarehousingAndDistribution\PrepOwner',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'label_owner' => null,
        'prep_category' => null,
        'prep_instructions' => null,
        'prep_owner' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'label_owner' => 'labelOwner',
        'prep_category' => 'prepCategory',
        'prep_instructions' => 'prepInstructions',
        'prep_owner' => 'prepOwner',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'label_owner' => 'setLabelOwner',
        'prep_category' => 'setPrepCategory',
        'prep_instructions' => 'setPrepInstructions',
        'prep_owner' => 'setPrepOwner',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'label_owner' => 'getLabelOwner',
        'prep_category' => 'getPrepCategory',
        'prep_instructions' => 'getPrepInstructions',
        'prep_owner' => 'getPrepOwner',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label_owner'] = $data['label_owner'] ?? null;
        $this->container['prep_category'] = $data['prep_category'] ?? null;
        $this->container['prep_instructions'] = $data['prep_instructions'] ?? null;
        $this->container['prep_owner'] = $data['prep_owner'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
    }

    /**
     * Gets label_owner.
     */
    public function getLabelOwner() : ?LabelOwner
    {
        return $this->container['label_owner'];
    }

    /**
     * Sets label_owner.
     *
     * @param null|LabelOwner $label_owner label_owner
     */
    public function setLabelOwner(?LabelOwner $label_owner) : self
    {
        $this->container['label_owner'] = $label_owner;

        return $this;
    }

    /**
     * Gets prep_category.
     */
    public function getPrepCategory() : ?string
    {
        return $this->container['prep_category'];
    }

    /**
     * Sets prep_category.
     *
     * @param null|string $prep_category the preparation category for shipping an item to Amazon's fulfillment network
     */
    public function setPrepCategory(?string $prep_category) : self
    {
        $this->container['prep_category'] = $prep_category;

        return $this;
    }

    /**
     * Gets prep_instructions.
     *
     * @return null|PrepInstruction[]
     */
    public function getPrepInstructions() : ?array
    {
        return $this->container['prep_instructions'];
    }

    /**
     * Sets prep_instructions.
     *
     * @param null|PrepInstruction[] $prep_instructions Information that pertains to the preparation of inbound products. This is generated based on the specified category.
     */
    public function setPrepInstructions(?array $prep_instructions) : self
    {
        $this->container['prep_instructions'] = $prep_instructions;

        return $this;
    }

    /**
     * Gets prep_owner.
     */
    public function getPrepOwner() : ?PrepOwner
    {
        return $this->container['prep_owner'];
    }

    /**
     * Sets prep_owner.
     *
     * @param null|PrepOwner $prep_owner prep_owner
     */
    public function setPrepOwner(?PrepOwner $prep_owner) : self
    {
        $this->container['prep_owner'] = $prep_owner;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
