<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorShipments;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Retail Procurement Shipments.
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ShipmentInformation implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const SHIP_MODE_SMALL_PARCEL = 'SmallParcel';

    final public const SHIP_MODE_LTL = 'LTL';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'ShipmentInformation';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'vendor_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\VendorDetails',
        'buyer_reference_number' => 'string',
        'ship_to_party' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PartyIdentification',
        'ship_from_party' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PartyIdentification',
        'warehouse_id' => 'string',
        'master_tracking_id' => 'string',
        'total_label_count' => 'int',
        'ship_mode' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'vendor_details' => null,
        'buyer_reference_number' => null,
        'ship_to_party' => null,
        'ship_from_party' => null,
        'warehouse_id' => null,
        'master_tracking_id' => null,
        'total_label_count' => null,
        'ship_mode' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'vendor_details' => 'vendorDetails',
        'buyer_reference_number' => 'buyerReferenceNumber',
        'ship_to_party' => 'shipToParty',
        'ship_from_party' => 'shipFromParty',
        'warehouse_id' => 'warehouseId',
        'master_tracking_id' => 'masterTrackingId',
        'total_label_count' => 'totalLabelCount',
        'ship_mode' => 'shipMode',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'vendor_details' => 'setVendorDetails',
        'buyer_reference_number' => 'setBuyerReferenceNumber',
        'ship_to_party' => 'setShipToParty',
        'ship_from_party' => 'setShipFromParty',
        'warehouse_id' => 'setWarehouseId',
        'master_tracking_id' => 'setMasterTrackingId',
        'total_label_count' => 'setTotalLabelCount',
        'ship_mode' => 'setShipMode',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'vendor_details' => 'getVendorDetails',
        'buyer_reference_number' => 'getBuyerReferenceNumber',
        'ship_to_party' => 'getShipToParty',
        'ship_from_party' => 'getShipFromParty',
        'warehouse_id' => 'getWarehouseId',
        'master_tracking_id' => 'getMasterTrackingId',
        'total_label_count' => 'getTotalLabelCount',
        'ship_mode' => 'getShipMode',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['vendor_details'] = $data['vendor_details'] ?? null;
        $this->container['buyer_reference_number'] = $data['buyer_reference_number'] ?? null;
        $this->container['ship_to_party'] = $data['ship_to_party'] ?? null;
        $this->container['ship_from_party'] = $data['ship_from_party'] ?? null;
        $this->container['warehouse_id'] = $data['warehouse_id'] ?? null;
        $this->container['master_tracking_id'] = $data['master_tracking_id'] ?? null;
        $this->container['total_label_count'] = $data['total_label_count'] ?? null;
        $this->container['ship_mode'] = $data['ship_mode'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getShipModeAllowableValues() : array
    {
        return [
            self::SHIP_MODE_SMALL_PARCEL,
            self::SHIP_MODE_LTL,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['vendor_details'] !== null) {
            $this->container['vendor_details']->validate();
        }

        if ($this->container['ship_to_party'] !== null) {
            $this->container['ship_to_party']->validate();
        }

        if ($this->container['ship_from_party'] !== null) {
            $this->container['ship_from_party']->validate();
        }

        $allowedValues = $this->getShipModeAllowableValues();

        if (null !== $this->container['ship_mode'] && !\in_array($this->container['ship_mode'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'ship_mode', must be one of '%s'",
                    $this->container['ship_mode'],
                    \implode("', '", $allowedValues)
                )
            );
        }
    }

    /**
     * Gets vendor_details.
     */
    public function getVendorDetails() : ?VendorDetails
    {
        return $this->container['vendor_details'];
    }

    /**
     * Sets vendor_details.
     *
     * @param null|VendorDetails $vendor_details vendor_details
     */
    public function setVendorDetails(?VendorDetails $vendor_details) : self
    {
        $this->container['vendor_details'] = $vendor_details;

        return $this;
    }

    /**
     * Gets buyer_reference_number.
     */
    public function getBuyerReferenceNumber() : ?string
    {
        return $this->container['buyer_reference_number'];
    }

    /**
     * Sets buyer_reference_number.
     *
     * @param null|string $buyer_reference_number the buyer reference number is a unique identifier generated by the buyer for all Collect and WePay shipments
     */
    public function setBuyerReferenceNumber(?string $buyer_reference_number) : self
    {
        $this->container['buyer_reference_number'] = $buyer_reference_number;

        return $this;
    }

    /**
     * Gets ship_to_party.
     */
    public function getShipToParty() : ?PartyIdentification
    {
        return $this->container['ship_to_party'];
    }

    /**
     * Sets ship_to_party.
     *
     * @param null|PartyIdentification $ship_to_party ship_to_party
     */
    public function setShipToParty(?PartyIdentification $ship_to_party) : self
    {
        $this->container['ship_to_party'] = $ship_to_party;

        return $this;
    }

    /**
     * Gets ship_from_party.
     */
    public function getShipFromParty() : ?PartyIdentification
    {
        return $this->container['ship_from_party'];
    }

    /**
     * Sets ship_from_party.
     *
     * @param null|PartyIdentification $ship_from_party ship_from_party
     */
    public function setShipFromParty(?PartyIdentification $ship_from_party) : self
    {
        $this->container['ship_from_party'] = $ship_from_party;

        return $this;
    }

    /**
     * Gets warehouse_id.
     */
    public function getWarehouseId() : ?string
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id.
     *
     * @param null|string $warehouse_id vendor Warehouse ID from where the shipment is scheduled to be picked up by buyer / Carrier
     */
    public function setWarehouseId(?string $warehouse_id) : self
    {
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }

    /**
     * Gets master_tracking_id.
     */
    public function getMasterTrackingId() : ?string
    {
        return $this->container['master_tracking_id'];
    }

    /**
     * Sets master_tracking_id.
     *
     * @param null|string $master_tracking_id unique Id with  which  the shipment can be tracked for Small Parcels
     */
    public function setMasterTrackingId(?string $master_tracking_id) : self
    {
        $this->container['master_tracking_id'] = $master_tracking_id;

        return $this;
    }

    /**
     * Gets total_label_count.
     */
    public function getTotalLabelCount() : ?int
    {
        return $this->container['total_label_count'];
    }

    /**
     * Sets total_label_count.
     *
     * @param null|int $total_label_count number of Labels that are created as part of this shipment
     */
    public function setTotalLabelCount(?int $total_label_count) : self
    {
        $this->container['total_label_count'] = $total_label_count;

        return $this;
    }

    /**
     * Gets ship_mode.
     */
    public function getShipMode() : ?string
    {
        return $this->container['ship_mode'];
    }

    /**
     * Sets ship_mode.
     *
     * @param null|string $ship_mode Type of shipment whether it is Small Parcel
     */
    public function setShipMode(?string $ship_mode) : self
    {
        $this->container['ship_mode'] = $ship_mode;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
