<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Orders;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Orders v0.
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Measurement implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const UNIT_OUNCES = 'OUNCES';

    final public const UNIT_POUNDS = 'POUNDS';

    final public const UNIT_KILOGRAMS = 'KILOGRAMS';

    final public const UNIT_GRAMS = 'GRAMS';

    final public const UNIT_MILLIGRAMS = 'MILLIGRAMS';

    final public const UNIT_INCHES = 'INCHES';

    final public const UNIT_FEET = 'FEET';

    final public const UNIT_METERS = 'METERS';

    final public const UNIT_CENTIMETERS = 'CENTIMETERS';

    final public const UNIT_MILLIMETERS = 'MILLIMETERS';

    final public const UNIT_SQUARE_METERS = 'SQUARE_METERS';

    final public const UNIT_SQUARE_CENTIMETERS = 'SQUARE_CENTIMETERS';

    final public const UNIT_SQUARE_FEET = 'SQUARE_FEET';

    final public const UNIT_SQUARE_INCHES = 'SQUARE_INCHES';

    final public const UNIT_GALLONS = 'GALLONS';

    final public const UNIT_PINTS = 'PINTS';

    final public const UNIT_QUARTS = 'QUARTS';

    final public const UNIT_FLUID_OUNCES = 'FLUID_OUNCES';

    final public const UNIT_LITERS = 'LITERS';

    final public const UNIT_CUBIC_METERS = 'CUBIC_METERS';

    final public const UNIT_CUBIC_FEET = 'CUBIC_FEET';

    final public const UNIT_CUBIC_INCHES = 'CUBIC_INCHES';

    final public const UNIT_CUBIC_CENTIMETERS = 'CUBIC_CENTIMETERS';

    final public const UNIT_COUNT = 'COUNT';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Measurement';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'unit' => 'string',
        'value' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'unit' => null,
        'value' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'unit' => 'Unit',
        'value' => 'Value',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'unit' => 'setUnit',
        'value' => 'setValue',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'unit' => 'getUnit',
        'value' => 'getValue',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['unit'] = $data['unit'] ?? null;
        $this->container['value'] = $data['value'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getUnitAllowableValues() : array
    {
        return [
            self::UNIT_OUNCES,
            self::UNIT_POUNDS,
            self::UNIT_KILOGRAMS,
            self::UNIT_GRAMS,
            self::UNIT_MILLIGRAMS,
            self::UNIT_INCHES,
            self::UNIT_FEET,
            self::UNIT_METERS,
            self::UNIT_CENTIMETERS,
            self::UNIT_MILLIMETERS,
            self::UNIT_SQUARE_METERS,
            self::UNIT_SQUARE_CENTIMETERS,
            self::UNIT_SQUARE_FEET,
            self::UNIT_SQUARE_INCHES,
            self::UNIT_GALLONS,
            self::UNIT_PINTS,
            self::UNIT_QUARTS,
            self::UNIT_FLUID_OUNCES,
            self::UNIT_LITERS,
            self::UNIT_CUBIC_METERS,
            self::UNIT_CUBIC_FEET,
            self::UNIT_CUBIC_INCHES,
            self::UNIT_CUBIC_CENTIMETERS,
            self::UNIT_COUNT,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['unit'] === null) {
            throw new AssertionException("'unit' can't be null");
        }

        $allowedValues = $this->getUnitAllowableValues();

        if (null !== $this->container['unit'] && !\in_array($this->container['unit'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'unit', must be one of '%s'",
                    $this->container['unit'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['value'] === null) {
            throw new AssertionException("'value' can't be null");
        }
    }

    /**
     * Gets unit.
     */
    public function getUnit() : string
    {
        return $this->container['unit'];
    }

    /**
     * Sets unit.
     *
     * @param string $unit the unit of measure
     */
    public function setUnit(string $unit) : self
    {
        $this->container['unit'] = $unit;

        return $this;
    }

    /**
     * Gets value.
     */
    public function getValue() : float
    {
        return $this->container['value'];
    }

    /**
     * Sets value.
     *
     * @param float $value the measurement value
     */
    public function setValue(float $value) : self
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
