<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\ListingsItems;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Listings Items.
 *
 * The Selling Partner API for Listings Items (Listings Items API) provides programmatic access to selling partner listings on Amazon. Use this API in collaboration with the Selling Partner API for Product Type Definitions, which you use to retrieve the information about Amazon product types needed to use the Listings Items API.  For more information, see the [Listings Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/listings-items-api-v2021-08-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2021-08-01
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Item implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Item';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'sku' => 'string',
        'summaries' => '\AmazonPHP\SellingPartner\Model\ListingsItems\ItemSummaryByMarketplace[]',
        'attributes' => 'array<string,mixed>',
        'issues' => '\AmazonPHP\SellingPartner\Model\ListingsItems\Issue[]',
        'offers' => '\AmazonPHP\SellingPartner\Model\ListingsItems\ItemOfferByMarketplace[]',
        'fulfillment_availability' => '\AmazonPHP\SellingPartner\Model\ListingsItems\FulfillmentAvailability[]',
        'procurement' => '\AmazonPHP\SellingPartner\Model\ListingsItems\ItemProcurement[]',
        'relationships' => '\AmazonPHP\SellingPartner\Model\ListingsItems\ItemRelationshipsByMarketplace[]',
        'product_types' => '\AmazonPHP\SellingPartner\Model\ListingsItems\ItemProductTypeByMarketplace[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'sku' => null,
        'summaries' => null,
        'attributes' => null,
        'issues' => null,
        'offers' => null,
        'fulfillment_availability' => null,
        'procurement' => null,
        'relationships' => null,
        'product_types' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'sku' => 'sku',
        'summaries' => 'summaries',
        'attributes' => 'attributes',
        'issues' => 'issues',
        'offers' => 'offers',
        'fulfillment_availability' => 'fulfillmentAvailability',
        'procurement' => 'procurement',
        'relationships' => 'relationships',
        'product_types' => 'productTypes',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'sku' => 'setSku',
        'summaries' => 'setSummaries',
        'attributes' => 'setAttributes',
        'issues' => 'setIssues',
        'offers' => 'setOffers',
        'fulfillment_availability' => 'setFulfillmentAvailability',
        'procurement' => 'setProcurement',
        'relationships' => 'setRelationships',
        'product_types' => 'setProductTypes',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'sku' => 'getSku',
        'summaries' => 'getSummaries',
        'attributes' => 'getAttributes',
        'issues' => 'getIssues',
        'offers' => 'getOffers',
        'fulfillment_availability' => 'getFulfillmentAvailability',
        'procurement' => 'getProcurement',
        'relationships' => 'getRelationships',
        'product_types' => 'getProductTypes',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['summaries'] = $data['summaries'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
        $this->container['issues'] = $data['issues'] ?? null;
        $this->container['offers'] = $data['offers'] ?? null;
        $this->container['fulfillment_availability'] = $data['fulfillment_availability'] ?? null;
        $this->container['procurement'] = $data['procurement'] ?? null;
        $this->container['relationships'] = $data['relationships'] ?? null;
        $this->container['product_types'] = $data['product_types'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['sku'] === null) {
            throw new AssertionException("'sku' can't be null");
        }
    }

    /**
     * Gets sku.
     */
    public function getSku() : string
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku.
     *
     * @param string $sku a selling partner provided identifier for an Amazon listing
     */
    public function setSku(string $sku) : self
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets summaries.
     *
     * @return null|ItemSummaryByMarketplace[]
     */
    public function getSummaries() : ?array
    {
        return $this->container['summaries'];
    }

    /**
     * Sets summaries.
     *
     * @param null|ItemSummaryByMarketplace[] $summaries summary details of a listings item
     */
    public function setSummaries(?array $summaries) : self
    {
        $this->container['summaries'] = $summaries;

        return $this;
    }

    /**
     * Gets attributes.
     *
     * @return null|array<string,mixed>
     */
    public function getAttributes() : ?array
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes.
     *
     * @param null|array<string,mixed> $attributes a JSON object containing structured listings item attribute data keyed by attribute name
     */
    public function setAttributes(?array $attributes) : self
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets issues.
     *
     * @return null|Issue[]
     */
    public function getIssues() : ?array
    {
        return $this->container['issues'];
    }

    /**
     * Sets issues.
     *
     * @param null|Issue[] $issues the issues associated with the listings item
     */
    public function setIssues(?array $issues) : self
    {
        $this->container['issues'] = $issues;

        return $this;
    }

    /**
     * Gets offers.
     *
     * @return null|ItemOfferByMarketplace[]
     */
    public function getOffers() : ?array
    {
        return $this->container['offers'];
    }

    /**
     * Sets offers.
     *
     * @param null|ItemOfferByMarketplace[] $offers offer details for the listings item
     */
    public function setOffers(?array $offers) : self
    {
        $this->container['offers'] = $offers;

        return $this;
    }

    /**
     * Gets fulfillment_availability.
     *
     * @return null|FulfillmentAvailability[]
     */
    public function getFulfillmentAvailability() : ?array
    {
        return $this->container['fulfillment_availability'];
    }

    /**
     * Sets fulfillment_availability.
     *
     * @param null|FulfillmentAvailability[] $fulfillment_availability the fulfillment availability for the listings item
     */
    public function setFulfillmentAvailability(?array $fulfillment_availability) : self
    {
        $this->container['fulfillment_availability'] = $fulfillment_availability;

        return $this;
    }

    /**
     * Gets procurement.
     *
     * @return null|ItemProcurement[]
     */
    public function getProcurement() : ?array
    {
        return $this->container['procurement'];
    }

    /**
     * Sets procurement.
     *
     * @param null|ItemProcurement[] $procurement the vendor procurement information for the listings item
     */
    public function setProcurement(?array $procurement) : self
    {
        $this->container['procurement'] = $procurement;

        return $this;
    }

    /**
     * Gets relationships.
     *
     * @return null|ItemRelationshipsByMarketplace[]
     */
    public function getRelationships() : ?array
    {
        return $this->container['relationships'];
    }

    /**
     * Sets relationships.
     *
     * @param null|ItemRelationshipsByMarketplace[] $relationships relationships for a listing item, by marketplace (for example, variations)
     */
    public function setRelationships(?array $relationships) : self
    {
        $this->container['relationships'] = $relationships;

        return $this;
    }

    /**
     * Gets product_types.
     *
     * @return null|ItemProductTypeByMarketplace[]
     */
    public function getProductTypes() : ?array
    {
        return $this->container['product_types'];
    }

    /**
     * Sets product_types.
     *
     * @param null|ItemProductTypeByMarketplace[] $product_types product types for a listing item, by marketplace
     */
    public function setProductTypes(?array $product_types) : self
    {
        $this->container['product_types'] = $product_types;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
