<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
class ReasonComment
{
    /**
     * Possible values of this enum.
     */
    final public const APPOINTMENT_REQUESTED_BY_MISTAKE = 'APPOINTMENT_REQUESTED_BY_MISTAKE';

    final public const VEHICLE_DELAY = 'VEHICLE_DELAY';

    final public const SLOT_NOT_SUITABLE = 'SLOT_NOT_SUITABLE';

    final public const OUTSIDE_CARRIER_BUSINESS_HOURS = 'OUTSIDE_CARRIER_BUSINESS_HOURS';

    final public const UNFAVOURABLE_EXTERNAL_CONDITIONS = 'UNFAVOURABLE_EXTERNAL_CONDITIONS';

    final public const PROCUREMENT_DELAY = 'PROCUREMENT_DELAY';

    final public const SHIPPING_PLAN_CHANGED = 'SHIPPING_PLAN_CHANGED';

    final public const INCREASED_QUANTITY = 'INCREASED_QUANTITY';

    final public const OTHER = 'OTHER';

    public function __construct(private readonly string $value)
    {
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public static function getAllowableEnumValues() : array
    {
        return [
            self::APPOINTMENT_REQUESTED_BY_MISTAKE,
            self::VEHICLE_DELAY,
            self::SLOT_NOT_SUITABLE,
            self::OUTSIDE_CARRIER_BUSINESS_HOURS,
            self::UNFAVOURABLE_EXTERNAL_CONDITIONS,
            self::PROCUREMENT_DELAY,
            self::SHIPPING_PLAN_CHANGED,
            self::INCREASED_QUANTITY,
            self::OTHER,
        ];
    }

    public function toString() : string
    {
        return $this->value;
    }
}
