<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PackingConfiguration implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'PackingConfiguration';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'box_packing_methods' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\BoxContentInformationSource[]',
        'box_requirements' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\BoxRequirements',
        'shipping_requirements' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ShippingRequirements[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'box_packing_methods' => null,
        'box_requirements' => null,
        'shipping_requirements' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'box_packing_methods' => 'boxPackingMethods',
        'box_requirements' => 'boxRequirements',
        'shipping_requirements' => 'shippingRequirements',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'box_packing_methods' => 'setBoxPackingMethods',
        'box_requirements' => 'setBoxRequirements',
        'shipping_requirements' => 'setShippingRequirements',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'box_packing_methods' => 'getBoxPackingMethods',
        'box_requirements' => 'getBoxRequirements',
        'shipping_requirements' => 'getShippingRequirements',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['box_packing_methods'] = $data['box_packing_methods'] ?? null;
        $this->container['box_requirements'] = $data['box_requirements'] ?? null;
        $this->container['shipping_requirements'] = $data['shipping_requirements'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['box_requirements'] !== null) {
            $this->container['box_requirements']->validate();
        }
    }

    /**
     * Gets box_packing_methods.
     *
     * @return null|BoxContentInformationSource[]
     */
    public function getBoxPackingMethods() : ?array
    {
        return $this->container['box_packing_methods'];
    }

    /**
     * Sets box_packing_methods.
     *
     * @param null|BoxContentInformationSource[] $box_packing_methods the box content information sources that are allowed
     */
    public function setBoxPackingMethods(?array $box_packing_methods) : self
    {
        $this->container['box_packing_methods'] = $box_packing_methods;

        return $this;
    }

    /**
     * Gets box_requirements.
     */
    public function getBoxRequirements() : ?BoxRequirements
    {
        return $this->container['box_requirements'];
    }

    /**
     * Sets box_requirements.
     *
     * @param null|BoxRequirements $box_requirements box_requirements
     */
    public function setBoxRequirements(?BoxRequirements $box_requirements) : self
    {
        $this->container['box_requirements'] = $box_requirements;

        return $this;
    }

    /**
     * Gets shipping_requirements.
     *
     * @return null|ShippingRequirements[]
     */
    public function getShippingRequirements() : ?array
    {
        return $this->container['shipping_requirements'];
    }

    /**
     * Sets shipping_requirements.
     *
     * @param null|ShippingRequirements[] $shipping_requirements a list of supported shipping requirements for this packing configuration
     */
    public function setShippingRequirements(?array $shipping_requirements) : self
    {
        $this->container['shipping_requirements'] = $shipping_requirements;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
