<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Item implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Item';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'asin' => 'string',
        'expiration' => 'string',
        'fnsku' => 'string',
        'label_owner' => 'string',
        'manufacturing_lot_code' => 'string',
        'msku' => 'string',
        'prep_instructions' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\PrepInstruction[]',
        'quantity' => 'int',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'asin' => null,
        'expiration' => null,
        'fnsku' => null,
        'label_owner' => null,
        'manufacturing_lot_code' => null,
        'msku' => null,
        'prep_instructions' => null,
        'quantity' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'asin' => 'asin',
        'expiration' => 'expiration',
        'fnsku' => 'fnsku',
        'label_owner' => 'labelOwner',
        'manufacturing_lot_code' => 'manufacturingLotCode',
        'msku' => 'msku',
        'prep_instructions' => 'prepInstructions',
        'quantity' => 'quantity',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'asin' => 'setAsin',
        'expiration' => 'setExpiration',
        'fnsku' => 'setFnsku',
        'label_owner' => 'setLabelOwner',
        'manufacturing_lot_code' => 'setManufacturingLotCode',
        'msku' => 'setMsku',
        'prep_instructions' => 'setPrepInstructions',
        'quantity' => 'setQuantity',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'asin' => 'getAsin',
        'expiration' => 'getExpiration',
        'fnsku' => 'getFnsku',
        'label_owner' => 'getLabelOwner',
        'manufacturing_lot_code' => 'getManufacturingLotCode',
        'msku' => 'getMsku',
        'prep_instructions' => 'getPrepInstructions',
        'quantity' => 'getQuantity',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['asin'] = $data['asin'] ?? null;
        $this->container['expiration'] = $data['expiration'] ?? null;
        $this->container['fnsku'] = $data['fnsku'] ?? null;
        $this->container['label_owner'] = $data['label_owner'] ?? null;
        $this->container['manufacturing_lot_code'] = $data['manufacturing_lot_code'] ?? null;
        $this->container['msku'] = $data['msku'] ?? null;
        $this->container['prep_instructions'] = $data['prep_instructions'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['asin'] === null) {
            throw new AssertionException("'asin' can't be null");
        }

        if ((\mb_strlen((string) $this->container['asin']) > 10)) {
            throw new AssertionException("invalid value for 'asin', the character length must be smaller than or equal to 10.");
        }

        if ((\mb_strlen((string) $this->container['asin']) < 1)) {
            throw new AssertionException("invalid value for 'asin', the character length must be bigger than or equal to 1.");
        }

        if (null !== $this->container['expiration'] && !\preg_match('/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/', (string) $this->container['expiration'])) {
            throw new AssertionException("invalid value for 'expiration', must be conform to the pattern /^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.");
        }

        if ($this->container['fnsku'] === null) {
            throw new AssertionException("'fnsku' can't be null");
        }

        if ((\mb_strlen((string) $this->container['fnsku']) > 10)) {
            throw new AssertionException("invalid value for 'fnsku', the character length must be smaller than or equal to 10.");
        }

        if ((\mb_strlen((string) $this->container['fnsku']) < 1)) {
            throw new AssertionException("invalid value for 'fnsku', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['label_owner'] === null) {
            throw new AssertionException("'label_owner' can't be null");
        }

        if ((\mb_strlen((string) $this->container['label_owner']) > 1024)) {
            throw new AssertionException("invalid value for 'label_owner', the character length must be smaller than or equal to 1024.");
        }

        if ((\mb_strlen((string) $this->container['label_owner']) < 1)) {
            throw new AssertionException("invalid value for 'label_owner', the character length must be bigger than or equal to 1.");
        }

        if (null !== $this->container['manufacturing_lot_code'] && (\mb_strlen((string) $this->container['manufacturing_lot_code']) > 256)) {
            throw new AssertionException("invalid value for 'manufacturing_lot_code', the character length must be smaller than or equal to 256.");
        }

        if (null !== $this->container['manufacturing_lot_code'] && (\mb_strlen((string) $this->container['manufacturing_lot_code']) < 1)) {
            throw new AssertionException("invalid value for 'manufacturing_lot_code', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['msku'] === null) {
            throw new AssertionException("'msku' can't be null");
        }

        if ((\mb_strlen((string) $this->container['msku']) > 40)) {
            throw new AssertionException("invalid value for 'msku', the character length must be smaller than or equal to 40.");
        }

        if ((\mb_strlen((string) $this->container['msku']) < 1)) {
            throw new AssertionException("invalid value for 'msku', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['prep_instructions'] === null) {
            throw new AssertionException("'prep_instructions' can't be null");
        }

        if ($this->container['quantity'] === null) {
            throw new AssertionException("'quantity' can't be null");
        }

        if (($this->container['quantity'] > 10000)) {
            throw new AssertionException("invalid value for 'quantity', must be smaller than or equal to 10000.");
        }

        if (($this->container['quantity'] < 1)) {
            throw new AssertionException("invalid value for 'quantity', must be bigger than or equal to 1.");
        }
    }

    /**
     * Gets asin.
     */
    public function getAsin() : string
    {
        return $this->container['asin'];
    }

    /**
     * Sets asin.
     *
     * @param string $asin the Amazon Standard Identification Number (ASIN) of the item
     */
    public function setAsin(string $asin) : self
    {
        $this->container['asin'] = $asin;

        return $this;
    }

    /**
     * Gets expiration.
     */
    public function getExpiration() : ?string
    {
        return $this->container['expiration'];
    }

    /**
     * Sets expiration.
     *
     * @param null|string $expiration The expiration date of the MSKU. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern`YYYY-MM-DD`. The same MSKU with different expiration dates cannot go into the same box.
     */
    public function setExpiration(?string $expiration) : self
    {
        $this->container['expiration'] = $expiration;

        return $this;
    }

    /**
     * Gets fnsku.
     */
    public function getFnsku() : string
    {
        return $this->container['fnsku'];
    }

    /**
     * Sets fnsku.
     *
     * @param string $fnsku a unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center
     */
    public function setFnsku(string $fnsku) : self
    {
        $this->container['fnsku'] = $fnsku;

        return $this;
    }

    /**
     * Gets label_owner.
     */
    public function getLabelOwner() : string
    {
        return $this->container['label_owner'];
    }

    /**
     * Sets label_owner.
     *
     * @param string $label_owner Specifies who will label the items. Options include `AMAZON`, `SELLER`, and `NONE`.
     */
    public function setLabelOwner(string $label_owner) : self
    {
        $this->container['label_owner'] = $label_owner;

        return $this;
    }

    /**
     * Gets manufacturing_lot_code.
     */
    public function getManufacturingLotCode() : ?string
    {
        return $this->container['manufacturing_lot_code'];
    }

    /**
     * Sets manufacturing_lot_code.
     *
     * @param null|string $manufacturing_lot_code the manufacturing lot code
     */
    public function setManufacturingLotCode(?string $manufacturing_lot_code) : self
    {
        $this->container['manufacturing_lot_code'] = $manufacturing_lot_code;

        return $this;
    }

    /**
     * Gets msku.
     */
    public function getMsku() : string
    {
        return $this->container['msku'];
    }

    /**
     * Sets msku.
     *
     * @param string $msku the merchant SKU, a merchant-supplied identifier of a specific SKU
     */
    public function setMsku(string $msku) : self
    {
        $this->container['msku'] = $msku;

        return $this;
    }

    /**
     * Gets prep_instructions.
     *
     * @return PrepInstruction[]
     */
    public function getPrepInstructions() : array
    {
        return $this->container['prep_instructions'];
    }

    /**
     * Sets prep_instructions.
     *
     * @param PrepInstruction[] $prep_instructions special preparations that are required for an item
     */
    public function setPrepInstructions(array $prep_instructions) : self
    {
        $this->container['prep_instructions'] = $prep_instructions;

        return $this;
    }

    /**
     * Gets quantity.
     */
    public function getQuantity() : int
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity.
     *
     * @param int $quantity the number of the specified MSKU
     */
    public function setQuantity(int $quantity) : self
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
