<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class AddressInput implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'AddressInput';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'address_line1' => 'string',
        'address_line2' => 'string',
        'city' => 'string',
        'company_name' => 'string',
        'country_code' => 'string',
        'email' => 'string',
        'name' => 'string',
        'phone_number' => 'string',
        'postal_code' => 'string',
        'state_or_province_code' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'address_line1' => null,
        'address_line2' => null,
        'city' => null,
        'company_name' => null,
        'country_code' => null,
        'email' => null,
        'name' => null,
        'phone_number' => null,
        'postal_code' => null,
        'state_or_province_code' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'address_line1' => 'addressLine1',
        'address_line2' => 'addressLine2',
        'city' => 'city',
        'company_name' => 'companyName',
        'country_code' => 'countryCode',
        'email' => 'email',
        'name' => 'name',
        'phone_number' => 'phoneNumber',
        'postal_code' => 'postalCode',
        'state_or_province_code' => 'stateOrProvinceCode',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'address_line1' => 'setAddressLine1',
        'address_line2' => 'setAddressLine2',
        'city' => 'setCity',
        'company_name' => 'setCompanyName',
        'country_code' => 'setCountryCode',
        'email' => 'setEmail',
        'name' => 'setName',
        'phone_number' => 'setPhoneNumber',
        'postal_code' => 'setPostalCode',
        'state_or_province_code' => 'setStateOrProvinceCode',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'address_line1' => 'getAddressLine1',
        'address_line2' => 'getAddressLine2',
        'city' => 'getCity',
        'company_name' => 'getCompanyName',
        'country_code' => 'getCountryCode',
        'email' => 'getEmail',
        'name' => 'getName',
        'phone_number' => 'getPhoneNumber',
        'postal_code' => 'getPostalCode',
        'state_or_province_code' => 'getStateOrProvinceCode',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['address_line1'] = $data['address_line1'] ?? null;
        $this->container['address_line2'] = $data['address_line2'] ?? null;
        $this->container['city'] = $data['city'] ?? null;
        $this->container['company_name'] = $data['company_name'] ?? null;
        $this->container['country_code'] = $data['country_code'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['phone_number'] = $data['phone_number'] ?? null;
        $this->container['postal_code'] = $data['postal_code'] ?? null;
        $this->container['state_or_province_code'] = $data['state_or_province_code'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['address_line1'] === null) {
            throw new AssertionException("'address_line1' can't be null");
        }

        if ((\mb_strlen((string) $this->container['address_line1']) > 180)) {
            throw new AssertionException("invalid value for 'address_line1', the character length must be smaller than or equal to 180.");
        }

        if ((\mb_strlen((string) $this->container['address_line1']) < 1)) {
            throw new AssertionException("invalid value for 'address_line1', the character length must be bigger than or equal to 1.");
        }

        if (null !== $this->container['address_line2'] && (\mb_strlen((string) $this->container['address_line2']) > 60)) {
            throw new AssertionException("invalid value for 'address_line2', the character length must be smaller than or equal to 60.");
        }

        if (null !== $this->container['address_line2'] && (\mb_strlen((string) $this->container['address_line2']) < 1)) {
            throw new AssertionException("invalid value for 'address_line2', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['city'] === null) {
            throw new AssertionException("'city' can't be null");
        }

        if ((\mb_strlen((string) $this->container['city']) > 30)) {
            throw new AssertionException("invalid value for 'city', the character length must be smaller than or equal to 30.");
        }

        if ((\mb_strlen((string) $this->container['city']) < 1)) {
            throw new AssertionException("invalid value for 'city', the character length must be bigger than or equal to 1.");
        }

        if (null !== $this->container['company_name'] && (\mb_strlen((string) $this->container['company_name']) > 50)) {
            throw new AssertionException("invalid value for 'company_name', the character length must be smaller than or equal to 50.");
        }

        if (null !== $this->container['company_name'] && (\mb_strlen((string) $this->container['company_name']) < 1)) {
            throw new AssertionException("invalid value for 'company_name', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['country_code'] === null) {
            throw new AssertionException("'country_code' can't be null");
        }

        if ((\mb_strlen((string) $this->container['country_code']) > 2)) {
            throw new AssertionException("invalid value for 'country_code', the character length must be smaller than or equal to 2.");
        }

        if ((\mb_strlen((string) $this->container['country_code']) < 2)) {
            throw new AssertionException("invalid value for 'country_code', the character length must be bigger than or equal to 2.");
        }

        if (!\preg_match('/^[A-Z]{2}$/', (string) $this->container['country_code'])) {
            throw new AssertionException("invalid value for 'country_code', must be conform to the pattern /^[A-Z]{2}$/.");
        }

        if (null !== $this->container['email'] && (\mb_strlen((string) $this->container['email']) > 1024)) {
            throw new AssertionException("invalid value for 'email', the character length must be smaller than or equal to 1024.");
        }

        if (null !== $this->container['email'] && (\mb_strlen((string) $this->container['email']) < 1)) {
            throw new AssertionException("invalid value for 'email', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['name'] === null) {
            throw new AssertionException("'name' can't be null");
        }

        if ((\mb_strlen((string) $this->container['name']) > 50)) {
            throw new AssertionException("invalid value for 'name', the character length must be smaller than or equal to 50.");
        }

        if ((\mb_strlen((string) $this->container['name']) < 1)) {
            throw new AssertionException("invalid value for 'name', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['phone_number'] === null) {
            throw new AssertionException("'phone_number' can't be null");
        }

        if ((\mb_strlen((string) $this->container['phone_number']) > 20)) {
            throw new AssertionException("invalid value for 'phone_number', the character length must be smaller than or equal to 20.");
        }

        if ((\mb_strlen((string) $this->container['phone_number']) < 1)) {
            throw new AssertionException("invalid value for 'phone_number', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['postal_code'] === null) {
            throw new AssertionException("'postal_code' can't be null");
        }

        if ((\mb_strlen((string) $this->container['postal_code']) > 32)) {
            throw new AssertionException("invalid value for 'postal_code', the character length must be smaller than or equal to 32.");
        }

        if ((\mb_strlen((string) $this->container['postal_code']) < 1)) {
            throw new AssertionException("invalid value for 'postal_code', the character length must be bigger than or equal to 1.");
        }

        if (null !== $this->container['state_or_province_code'] && (\mb_strlen((string) $this->container['state_or_province_code']) > 64)) {
            throw new AssertionException("invalid value for 'state_or_province_code', the character length must be smaller than or equal to 64.");
        }

        if (null !== $this->container['state_or_province_code'] && (\mb_strlen((string) $this->container['state_or_province_code']) < 1)) {
            throw new AssertionException("invalid value for 'state_or_province_code', the character length must be bigger than or equal to 1.");
        }
    }

    /**
     * Gets address_line1.
     */
    public function getAddressLine1() : string
    {
        return $this->container['address_line1'];
    }

    /**
     * Sets address_line1.
     *
     * @param string $address_line1 street address information
     */
    public function setAddressLine1(string $address_line1) : self
    {
        $this->container['address_line1'] = $address_line1;

        return $this;
    }

    /**
     * Gets address_line2.
     */
    public function getAddressLine2() : ?string
    {
        return $this->container['address_line2'];
    }

    /**
     * Sets address_line2.
     *
     * @param null|string $address_line2 additional street address information
     */
    public function setAddressLine2(?string $address_line2) : self
    {
        $this->container['address_line2'] = $address_line2;

        return $this;
    }

    /**
     * Gets city.
     */
    public function getCity() : string
    {
        return $this->container['city'];
    }

    /**
     * Sets city.
     *
     * @param string $city the city
     */
    public function setCity(string $city) : self
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets company_name.
     */
    public function getCompanyName() : ?string
    {
        return $this->container['company_name'];
    }

    /**
     * Sets company_name.
     *
     * @param null|string $company_name the name of the business
     */
    public function setCompanyName(?string $company_name) : self
    {
        $this->container['company_name'] = $company_name;

        return $this;
    }

    /**
     * Gets country_code.
     */
    public function getCountryCode() : string
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code.
     *
     * @param string $country_code the country code in two-character ISO 3166-1 alpha-2 format
     */
    public function setCountryCode(string $country_code) : self
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets email.
     */
    public function getEmail() : ?string
    {
        return $this->container['email'];
    }

    /**
     * Sets email.
     *
     * @param null|string $email the email address
     */
    public function setEmail(?string $email) : self
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets name.
     */
    public function getName() : string
    {
        return $this->container['name'];
    }

    /**
     * Sets name.
     *
     * @param string $name the name of the individual who is the primary contact
     */
    public function setName(string $name) : self
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phone_number.
     */
    public function getPhoneNumber() : string
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number.
     *
     * @param string $phone_number the phone number
     */
    public function setPhoneNumber(string $phone_number) : self
    {
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets postal_code.
     */
    public function getPostalCode() : string
    {
        return $this->container['postal_code'];
    }

    /**
     * Sets postal_code.
     *
     * @param string $postal_code the postal code
     */
    public function setPostalCode(string $postal_code) : self
    {
        $this->container['postal_code'] = $postal_code;

        return $this;
    }

    /**
     * Gets state_or_province_code.
     */
    public function getStateOrProvinceCode() : ?string
    {
        return $this->container['state_or_province_code'];
    }

    /**
     * Sets state_or_province_code.
     *
     * @param null|string $state_or_province_code the state or province code
     */
    public function setStateOrProvinceCode(?string $state_or_province_code) : self
    {
        $this->container['state_or_province_code'] = $state_or_province_code;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
