<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\VendorShippingApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * Selling Partner API for Direct Fulfillment Shipping.
 *
 * Use the Selling Partner API for Direct Fulfillment Shipping to access a direct fulfillment vendor's shipping data.
 *
 * The version of the OpenAPI document: 2021-12-28
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface VendorDirectFulfillmentShippingSDKInterface
{
    public const API_NAME = 'VendorDirectFulfillmentShipping';

    public const OPERATION_GETPACKINGSLIP = 'getPackingSlip';

    public const OPERATION_GETPACKINGSLIP_PATH = '/vendor/directFulfillment/shipping/2021-12-28/packingSlips/{purchaseOrderNumber}';

    public const OPERATION_GETPACKINGSLIPS = 'getPackingSlips';

    public const OPERATION_GETPACKINGSLIPS_PATH = '/vendor/directFulfillment/shipping/2021-12-28/packingSlips';

    public const OPERATION_SUBMITSHIPMENTCONFIRMATIONS = 'submitShipmentConfirmations';

    public const OPERATION_SUBMITSHIPMENTCONFIRMATIONS_PATH = '/vendor/directFulfillment/shipping/2021-12-28/shipmentConfirmations';

    public const OPERATION_SUBMITSHIPMENTSTATUSUPDATES = 'submitShipmentStatusUpdates';

    public const OPERATION_SUBMITSHIPMENTSTATUSUPDATES_PATH = '/vendor/directFulfillment/shipping/2021-12-28/shipmentStatusUpdates';

    /**
     * Operation getPackingSlip.
     *
     * getPackingSlip
     *
     * @param string $purchase_order_number The &#x60;purchaseOrderNumber&#x60; for the packing slip that you want. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getPackingSlip(AccessToken $accessToken, string $region, string $purchase_order_number) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\PackingSlip;

    /**
     * Operation getPackingSlips.
     *
     * getPackingSlips
     *
     * @param \DateTimeInterface $created_after Packing slips that become available after this date and time will be included in the result. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. (required)
     * @param \DateTimeInterface $created_before Packing slips that became available before this date and time will be included in the result. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. (required)
     * @param null|string $ship_from_party_id The vendor &#x60;warehouseId&#x60; for order fulfillment. If not specified, the result contains orders for all warehouses. (optional)
     * @param null|int $limit The maximum number of records to return. (optional)
     * @param null|string $sort_order The packing slip creation dates, which are sorted by ascending or descending order. (optional, default to 'ASC')
     * @param null|string $next_token Used for pagination when there are more packing slips than the specified result size limit. The token value is returned in the previous API call. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getPackingSlips(AccessToken $accessToken, string $region, \DateTimeInterface $created_after, \DateTimeInterface $created_before, ?string $ship_from_party_id = null, ?int $limit = null, ?string $sort_order = 'ASC', ?string $next_token = null) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\PackingSlipList;

    /**
     * Operation submitShipmentConfirmations.
     *
     * submitShipmentConfirmations
     *
     * @param \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\SubmitShipmentConfirmationsRequest $body Request body containing the shipment confirmations data. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function submitShipmentConfirmations(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\SubmitShipmentConfirmationsRequest $body) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\TransactionReference;

    /**
     * Operation submitShipmentStatusUpdates.
     *
     * submitShipmentStatusUpdates
     *
     * @param \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\SubmitShipmentStatusUpdatesRequest $body Request body containing the shipment status update data. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function submitShipmentStatusUpdates(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\SubmitShipmentStatusUpdatesRequest $body) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\TransactionReference;
}
