<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\UpdateInventoryApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * Selling Partner API for Direct Fulfillment Inventory Updates.
 *
 * The Selling Partner API for Direct Fulfillment Inventory Updates provides programmatic access to a direct fulfillment vendor's inventory updates.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface VendorDirectFulfillmentInventorySDKInterface
{
    public const API_NAME = 'VendorDirectFulfillmentInventory';

    public const OPERATION_SUBMITINVENTORYUPDATE = 'submitInventoryUpdate';

    public const OPERATION_SUBMITINVENTORYUPDATE_PATH = '/vendor/directFulfillment/inventory/v1/warehouses/{warehouseId}/items';

    /**
     * Operation submitInventoryUpdate.
     *
     * @param string $warehouse_id Identifier for the warehouse for which to update inventory. (required)
     * @param \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentInventory\SubmitInventoryUpdateRequest $body The request body containing the inventory update data to submit. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function submitInventoryUpdate(AccessToken $accessToken, string $region, string $warehouse_id, \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentInventory\SubmitInventoryUpdateRequest $body) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentInventory\SubmitInventoryUpdateResponse;
}
