<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\FbaInboundApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface FulfillmentInboundSDKInterface
{
    public const API_NAME = 'FulfillmentInbound';

    public const OPERATION_CANCELINBOUNDPLAN = 'cancelInboundPlan';

    public const OPERATION_CANCELINBOUNDPLAN_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/cancellation';

    public const OPERATION_CANCELSELFSHIPAPPOINTMENT = 'cancelSelfShipAppointment';

    public const OPERATION_CANCELSELFSHIPAPPOINTMENT_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentCancellation';

    public const OPERATION_CONFIRMDELIVERYWINDOWOPTIONS = 'confirmDeliveryWindowOptions';

    public const OPERATION_CONFIRMDELIVERYWINDOWOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions/{deliveryWindowOptionId}/confirmation';

    public const OPERATION_CONFIRMPACKINGOPTION = 'confirmPackingOption';

    public const OPERATION_CONFIRMPACKINGOPTION_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions/{packingOptionId}/confirmation';

    public const OPERATION_CONFIRMPLACEMENTOPTION = 'confirmPlacementOption';

    public const OPERATION_CONFIRMPLACEMENTOPTION_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions/{placementOptionId}/confirmation';

    public const OPERATION_CONFIRMSHIPMENTCONTENTUPDATEPREVIEW = 'confirmShipmentContentUpdatePreview';

    public const OPERATION_CONFIRMSHIPMENTCONTENTUPDATEPREVIEW_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews/{contentUpdatePreviewId}/confirmation';

    public const OPERATION_CONFIRMTRANSPORTATIONOPTIONS = 'confirmTransportationOptions';

    public const OPERATION_CONFIRMTRANSPORTATIONOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions/confirmation';

    public const OPERATION_CREATEINBOUNDPLAN = 'createInboundPlan';

    public const OPERATION_CREATEINBOUNDPLAN_PATH = '/inbound/fba/2024-03-20/inboundPlans';

    public const OPERATION_CREATEMARKETPLACEITEMLABELS = 'createMarketplaceItemLabels';

    public const OPERATION_CREATEMARKETPLACEITEMLABELS_PATH = '/inbound/fba/2024-03-20/items/labels';

    public const OPERATION_GENERATEDELIVERYWINDOWOPTIONS = 'generateDeliveryWindowOptions';

    public const OPERATION_GENERATEDELIVERYWINDOWOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions';

    public const OPERATION_GENERATEPACKINGOPTIONS = 'generatePackingOptions';

    public const OPERATION_GENERATEPACKINGOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions';

    public const OPERATION_GENERATEPLACEMENTOPTIONS = 'generatePlacementOptions';

    public const OPERATION_GENERATEPLACEMENTOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions';

    public const OPERATION_GENERATESELFSHIPAPPOINTMENTSLOTS = 'generateSelfShipAppointmentSlots';

    public const OPERATION_GENERATESELFSHIPAPPOINTMENTSLOTS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots';

    public const OPERATION_GENERATESHIPMENTCONTENTUPDATEPREVIEWS = 'generateShipmentContentUpdatePreviews';

    public const OPERATION_GENERATESHIPMENTCONTENTUPDATEPREVIEWS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews';

    public const OPERATION_GENERATETRANSPORTATIONOPTIONS = 'generateTransportationOptions';

    public const OPERATION_GENERATETRANSPORTATIONOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions';

    public const OPERATION_GETDELIVERYCHALLANDOCUMENT = 'getDeliveryChallanDocument';

    public const OPERATION_GETDELIVERYCHALLANDOCUMENT_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryChallanDocument';

    public const OPERATION_GETINBOUNDOPERATIONSTATUS = 'getInboundOperationStatus';

    public const OPERATION_GETINBOUNDOPERATIONSTATUS_PATH = '/inbound/fba/2024-03-20/operations/{operationId}';

    public const OPERATION_GETINBOUNDPLAN = 'getInboundPlan';

    public const OPERATION_GETINBOUNDPLAN_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}';

    public const OPERATION_GETSELFSHIPAPPOINTMENTSLOTS = 'getSelfShipAppointmentSlots';

    public const OPERATION_GETSELFSHIPAPPOINTMENTSLOTS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots';

    public const OPERATION_GETSHIPMENT = 'getShipment';

    public const OPERATION_GETSHIPMENT_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}';

    public const OPERATION_GETSHIPMENTCONTENTUPDATEPREVIEW = 'getShipmentContentUpdatePreview';

    public const OPERATION_GETSHIPMENTCONTENTUPDATEPREVIEW_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews/{contentUpdatePreviewId}';

    public const OPERATION_LISTDELIVERYWINDOWOPTIONS = 'listDeliveryWindowOptions';

    public const OPERATION_LISTDELIVERYWINDOWOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions';

    public const OPERATION_LISTINBOUNDPLANBOXES = 'listInboundPlanBoxes';

    public const OPERATION_LISTINBOUNDPLANBOXES_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/boxes';

    public const OPERATION_LISTINBOUNDPLANITEMS = 'listInboundPlanItems';

    public const OPERATION_LISTINBOUNDPLANITEMS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/items';

    public const OPERATION_LISTINBOUNDPLANPALLETS = 'listInboundPlanPallets';

    public const OPERATION_LISTINBOUNDPLANPALLETS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/pallets';

    public const OPERATION_LISTINBOUNDPLANS = 'listInboundPlans';

    public const OPERATION_LISTINBOUNDPLANS_PATH = '/inbound/fba/2024-03-20/inboundPlans';

    public const OPERATION_LISTITEMCOMPLIANCEDETAILS = 'listItemComplianceDetails';

    public const OPERATION_LISTITEMCOMPLIANCEDETAILS_PATH = '/inbound/fba/2024-03-20/items/compliance';

    public const OPERATION_LISTPACKINGGROUPBOXES = 'listPackingGroupBoxes';

    public const OPERATION_LISTPACKINGGROUPBOXES_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingGroups/{packingGroupId}/boxes';

    public const OPERATION_LISTPACKINGGROUPITEMS = 'listPackingGroupItems';

    public const OPERATION_LISTPACKINGGROUPITEMS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingGroups/{packingGroupId}/items';

    public const OPERATION_LISTPACKINGOPTIONS = 'listPackingOptions';

    public const OPERATION_LISTPACKINGOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions';

    public const OPERATION_LISTPLACEMENTOPTIONS = 'listPlacementOptions';

    public const OPERATION_LISTPLACEMENTOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions';

    public const OPERATION_LISTPREPDETAILS = 'listPrepDetails';

    public const OPERATION_LISTPREPDETAILS_PATH = '/inbound/fba/2024-03-20/items/prepDetails';

    public const OPERATION_LISTSHIPMENTBOXES = 'listShipmentBoxes';

    public const OPERATION_LISTSHIPMENTBOXES_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/boxes';

    public const OPERATION_LISTSHIPMENTCONTENTUPDATEPREVIEWS = 'listShipmentContentUpdatePreviews';

    public const OPERATION_LISTSHIPMENTCONTENTUPDATEPREVIEWS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews';

    public const OPERATION_LISTSHIPMENTITEMS = 'listShipmentItems';

    public const OPERATION_LISTSHIPMENTITEMS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/items';

    public const OPERATION_LISTSHIPMENTPALLETS = 'listShipmentPallets';

    public const OPERATION_LISTSHIPMENTPALLETS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/pallets';

    public const OPERATION_LISTTRANSPORTATIONOPTIONS = 'listTransportationOptions';

    public const OPERATION_LISTTRANSPORTATIONOPTIONS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions';

    public const OPERATION_SCHEDULESELFSHIPAPPOINTMENT = 'scheduleSelfShipAppointment';

    public const OPERATION_SCHEDULESELFSHIPAPPOINTMENT_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots/{slotId}/schedule';

    public const OPERATION_SETPACKINGINFORMATION = 'setPackingInformation';

    public const OPERATION_SETPACKINGINFORMATION_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingInformation';

    public const OPERATION_SETPREPDETAILS = 'setPrepDetails';

    public const OPERATION_SETPREPDETAILS_PATH = '/inbound/fba/2024-03-20/items/prepDetails';

    public const OPERATION_UPDATEINBOUNDPLANNAME = 'updateInboundPlanName';

    public const OPERATION_UPDATEINBOUNDPLANNAME_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/name';

    public const OPERATION_UPDATEITEMCOMPLIANCEDETAILS = 'updateItemComplianceDetails';

    public const OPERATION_UPDATEITEMCOMPLIANCEDETAILS_PATH = '/inbound/fba/2024-03-20/items/compliance';

    public const OPERATION_UPDATESHIPMENTNAME = 'updateShipmentName';

    public const OPERATION_UPDATESHIPMENTNAME_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/name';

    public const OPERATION_UPDATESHIPMENTSOURCEADDRESS = 'updateShipmentSourceAddress';

    public const OPERATION_UPDATESHIPMENTSOURCEADDRESS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/sourceAddress';

    public const OPERATION_UPDATESHIPMENTTRACKINGDETAILS = 'updateShipmentTrackingDetails';

    public const OPERATION_UPDATESHIPMENTTRACKINGDETAILS_PATH = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/trackingDetails';

    /**
     * Operation cancelInboundPlan.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelInboundPlan(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelInboundPlanResponse;

    /**
     * Operation cancelSelfShipAppointment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body The body of the request to &#x60;cancelSelfShipAppointment&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelSelfShipAppointment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentResponse;

    /**
     * Operation confirmDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to confirm the delivery window option for. (required)
     * @param string $delivery_window_option_id The id of the delivery window option to be confirmed. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $delivery_window_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmDeliveryWindowOptionsResponse;

    /**
     * Operation confirmPackingOption.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_option_id Identifier of a packing option. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmPackingOption(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPackingOptionResponse;

    /**
     * Operation confirmPlacementOption.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $placement_option_id The identifier of a placement option. A placement option represents the shipment splits and destinations of SKUs. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmPlacementOption(AccessToken $accessToken, string $region, string $inbound_plan_id, string $placement_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPlacementOptionResponse;

    /**
     * Operation confirmShipmentContentUpdatePreview.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmShipmentContentUpdatePreview(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmShipmentContentUpdatePreviewResponse;

    /**
     * Operation confirmTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body The body of the request to &#x60;confirmTransportationOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsResponse;

    /**
     * Operation createInboundPlan.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body The body of the request to &#x60;createInboundPlan&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createInboundPlan(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanResponse;

    /**
     * Operation createMarketplaceItemLabels.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body The body of the request to &#x60;createMarketplaceItemLabels&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createMarketplaceItemLabels(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsResponse;

    /**
     * Operation generateDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to generate delivery window options for. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateDeliveryWindowOptionsResponse;

    /**
     * Operation generatePackingOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generatePackingOptions(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePackingOptionsResponse;

    /**
     * Operation generatePlacementOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body The body of the request to &#x60;generatePlacementOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generatePlacementOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsResponse;

    /**
     * Operation generateSelfShipAppointmentSlots.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body The body of the request to &#x60;generateSelfShipAppointmentSlots&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateSelfShipAppointmentSlots(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsResponse;

    /**
     * Operation generateShipmentContentUpdatePreviews.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body The body of the request to &#x60;generateShipmentContentUpdatePreviews&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateShipmentContentUpdatePreviews(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsResponse;

    /**
     * Operation generateTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body The body of the request to &#x60;generateTransportationOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsResponse;

    /**
     * Operation getDeliveryChallanDocument.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getDeliveryChallanDocument(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetDeliveryChallanDocumentResponse;

    /**
     * Operation getInboundOperationStatus.
     *
     * @param string $operation_id Identifier of an asynchronous operation. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getInboundOperationStatus(AccessToken $accessToken, string $region, string $operation_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundOperationStatus;

    /**
     * Operation getInboundPlan.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getInboundPlan(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundPlan;

    /**
     * Operation getSelfShipAppointmentSlots.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of self ship appointment slots to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getSelfShipAppointmentSlots(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetSelfShipAppointmentSlotsResponse;

    /**
     * Operation getShipment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getShipment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\Shipment;

    /**
     * Operation getShipmentContentUpdatePreview.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getShipmentContentUpdatePreview(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ContentUpdatePreview;

    /**
     * Operation listDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to get delivery window options for. (required)
     * @param null|int $page_size The number of delivery window options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListDeliveryWindowOptionsResponse;

    /**
     * Operation listInboundPlanBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanBoxesResponse;

    /**
     * Operation listInboundPlanItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanItems(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanItemsResponse;

    /**
     * Operation listInboundPlanPallets.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanPallets(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanPalletsResponse;

    /**
     * Operation listInboundPlans.
     *
     * @param null|int $page_size The number of inbound plans to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $status The status of an inbound plan. (optional)
     * @param null|string $sort_by Sort by field. (optional)
     * @param null|string $sort_order The sort order. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlans(AccessToken $accessToken, string $region, ?int $page_size = 10, ?string $pagination_token = null, ?string $status = null, ?string $sort_by = null, ?string $sort_order = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlansResponse;

    /**
     * Operation listItemComplianceDetails.
     *
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listItemComplianceDetails(AccessToken $accessToken, string $region, array $mskus, string $marketplace_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListItemComplianceDetailsResponse;

    /**
     * Operation listPackingGroupBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingGroupBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupBoxesResponse;

    /**
     * Operation listPackingGroupItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingGroupItems(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupItemsResponse;

    /**
     * Operation listPackingOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of packing options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingOptionsResponse;

    /**
     * Operation listPlacementOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of placement options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPlacementOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPlacementOptionsResponse;

    /**
     * Operation listPrepDetails.
     *
     * @param string $marketplace_id The marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPrepDetails(AccessToken $accessToken, string $region, string $marketplace_id, array $mskus) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPrepDetailsResponse;

    /**
     * Operation listShipmentBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentBoxesResponse;

    /**
     * Operation listShipmentContentUpdatePreviews.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of content update previews to return. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentContentUpdatePreviews(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentContentUpdatePreviewsResponse;

    /**
     * Operation listShipmentItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentItems(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentItemsResponse;

    /**
     * Operation listShipmentPallets.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentPallets(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentPalletsResponse;

    /**
     * Operation listTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of transportation options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $placement_option_id The placement option to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     * @param null|string $shipment_id The shipment to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null, ?string $placement_option_id = null, ?string $shipment_id = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListTransportationOptionsResponse;

    /**
     * Operation scheduleSelfShipAppointment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $slot_id An identifier to a self-ship appointment slot. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body The body of the request to &#x60;scheduleSelfShipAppointment&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function scheduleSelfShipAppointment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $slot_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentResponse;

    /**
     * Operation setPackingInformation.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body The body of the request to &#x60;setPackingInformation&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function setPackingInformation(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationResponse;

    /**
     * Operation setPrepDetails.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body The body of the request to &#x60;setPrepDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function setPrepDetails(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsResponse;

    /**
     * Operation updateInboundPlanName.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body The body of the request to &#x60;updateInboundPlanName&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateInboundPlanName(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body);

    /**
     * Operation updateItemComplianceDetails.
     *
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body The body of the request to &#x60;updateItemComplianceDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateItemComplianceDetails(AccessToken $accessToken, string $region, string $marketplace_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsResponse;

    /**
     * Operation updateShipmentName.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body The body of the request to &#x60;updateShipmentName&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentName(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body);

    /**
     * Operation updateShipmentSourceAddress.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body The body of the request to &#x60;updateShipmentSourceAddress&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentSourceAddress(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressResponse;

    /**
     * Operation updateShipmentTrackingDetails.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body The body of the request to &#x60;updateShipmentTrackingDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentTrackingDetails(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsResponse;
}
