<?php

require_once __DIR__ . '/vendor/autoload.php';

use AmazonPHP\SellingPartner\OAuth;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\Marketplace;
use AmazonPHP\SellingPartner\Regions;
use AmazonPHP\SellingPartner\SellingPartnerSDK;
use GuzzleHttp\Client as GuzzleClient;
use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Log\NullLogger;
use AmazonPHP\SellingPartner\Model\ListingsItems\ListingsItemPutRequest;
use AmazonPHP\SellingPartner\Api\DefinitionsApi\ProductTypesDefinitionsSDK;
use AmazonPHP\SellingPartner\Model\ProductTypesDefinitions\ProductTypeDefinition;
use AmazonPHP\SellingPartner\Api\ListingsItems;

// Load configuration
$config = require_once __DIR__ . '/config.php';

// Create HTTP factory and client
$factory = new Psr17Factory();
$client = new GuzzleClient();
$httpFactory = new HttpFactory($factory, $factory);
$logger = new NullLogger(); // Create logger instance

// Create OAuth instance
$oauth = new OAuth(
    $client,
    $httpFactory,
    $configuration = Configuration::forIAMUser(
        $config['lwa_client_id'],
        $config['lwa_client_secret'],
        $config['aws_access_key'],
        $config['aws_secret_key']
    ),
    $logger // Add the logger as the 4th parameter
);

// Exchange refresh token for access token
try {
    $accessToken = $oauth->exchangeRefreshToken($config['refresh_token']);
    echo "Successfully obtained access token\n";
    
    // Initialize the SDK
    $sdk = SellingPartnerSDK::create(
        $client,
        $factory, // Pass the RequestFactoryInterface directly
        $factory, // Pass the StreamFactoryInterface directly
        $configuration,
        $logger
    );
    
    echo "SDK initialized successfully\n";


} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}