<?php

require_once __DIR__ . '/vendor/autoload.php';

use AmazonPHP\SellingPartner\OAuth;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\Marketplace;
use AmazonPHP\SellingPartner\Regions;
use AmazonPHP\SellingPartner\SellingPartnerSDK;
use GuzzleHttp\Client as GuzzleClient;
use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Log\NullLogger;
use AmazonPHP\SellingPartner\Model\ListingsItems\ListingsItemPutRequest;
use AmazonPHP\SellingPartner\Api\DefinitionsApi\ProductTypesDefinitionsSDK;
use AmazonPHP\SellingPartner\Model\ProductTypesDefinitions\ProductTypeDefinition;

// Load configuration
$config = require_once __DIR__ . '/config.php';

// Create HTTP factory and client
$factory = new Psr17Factory();
$client = new GuzzleClient();
$httpFactory = new HttpFactory($factory, $factory);
$logger = new NullLogger(); // Create logger instance

// Create OAuth instance
$oauth = new OAuth(
    $client,
    $httpFactory,
    $configuration = Configuration::forIAMUser(
        $config['lwa_client_id'],
        $config['lwa_client_secret'],
        $config['aws_access_key'],
        $config['aws_secret_key']
    ),
    $logger // Add the logger as the 4th parameter
);

// Exchange refresh token for access token
try {
    $accessToken = $oauth->exchangeRefreshToken($config['refresh_token']);
    echo "Successfully obtained access token\n";
    
    // Initialize the SDK
    $sdk = SellingPartnerSDK::create(
        $client,
        $factory, // Pass the RequestFactoryInterface directly
        $factory, // Pass the StreamFactoryInterface directly
        $configuration,
        $logger
    );
    
    echo "SDK initialized successfully\n";
    $productType = 'LUGGAGE';
    $marketplace_id = 'ATVPDKIKX0DER'; // US marketplace ID

    $attributes = [
        "condition_type" => [
            [
                "value" => "new_new",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_name" => [
            [
                "value" => "Jetstream C1000 S3 GRN 20 Hardside Spinner Carry-On",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "country_of_origin" => [
            [
                "value" => "US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "material" => [
            [
                "value" => "Polycarbonate",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "main_product_image" => [
            [
                "link" => "data:image/jpeg;base64,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",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "merchant_suggested_asin" => [
            [
                "value" => "B07Z49J214",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "color" => [
            [
                "value" => "Black",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_package_dimensions" => [
            [
                "length" => [
                    "value" => 28,
                    "unit" => "inches"
                ],
                "width" => [
                    "value" => 18,
                    "unit" => "inches"
                ],
                "height" => [
                    "value" => 10,
                    "unit" => "inches"
                ],
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "brand" => [
            [
                "value" => "TravelMate",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_package_weight" => [
            [
                "value" => 14.89,
                "unit" => "pounds",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "batteries_required" => [
            [
                "value" => false,
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "product_description" => [
            [
                "value" => "Durable spinner suitcase perfect for travel.",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "supplier_declared_dg_hz_regulation" => [
            [
                "value" => "not_applicable",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "list_price" => [
            [
                "value" => 64.00,
                "currency" => "USD",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "externally_assigned_product_identifier" => [
            [
                "value" => "611419975041",
                "type" => "UPC",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "model_name" => [
            [
                "value" => "TM-Spinner-2024",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "style" => [
            [
                "value" => "Modern",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "bullet_point" => [
            [
                "value" => "Lightweight and durable",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ],
            [
                "value" => "360° spinner wheels for smooth movement",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_type_keyword" => [
            [
                "value" => "spinner-suitcases",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "department" => [
            [
                "value" => "unisex-adult",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "model_number" => [
            [
                "value" => "TM1001",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ]
    ];
    
    
    $body = new ListingsItemPutRequest([ 
        'product_type' => 'LUGGAGE', 
        'requirements' => 'LISTING', 
        'attributes' => $attributes, 
    ]); 

    $sku = 'NF00CLG3ENT'; 
    $merchant_id = 'A2HDH9PWY7LP2W'; // Replace with your Merchant ID

    $result = $sdk->listingsItems()->putListingsItem( 
        $accessToken, 
        'us-east-1', 
        $merchant_id, 
        $sku, 
        [$marketplace_id], 
        $body, 
        null 
    ); 

    echo "Listing created successfully:\n"; 
    print_r(json_encode($result)); 
    
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}