<?php

require_once __DIR__ . '/vendor/autoload.php';

use AmazonPHP\SellingPartner\OAuth;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\Marketplace;
use AmazonPHP\SellingPartner\Regions;
use AmazonPHP\SellingPartner\SellingPartnerSDK;
use GuzzleHttp\Client as GuzzleClient;
use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Log\NullLogger;
use AmazonPHP\SellingPartner\Model\ListingsItems\ListingsItemPutRequest;

// Load configuration
$config = require_once __DIR__ . '/config.php';

// Create HTTP factory and client
$factory = new Psr17Factory();
$client = new GuzzleClient();
$httpFactory = new HttpFactory($factory, $factory);
$logger = new NullLogger(); // Create logger instance

// Create OAuth instance
$oauth = new OAuth(
    $client,
    $httpFactory,
    $configuration = Configuration::forIAMUser(
        $config['lwa_client_id'],
        $config['lwa_client_secret'],
        $config['aws_access_key'],
        $config['aws_secret_key']
    ),
    $logger // Add the logger as the 4th parameter
);

// Exchange refresh token for access token
try {
    $accessToken = $oauth->exchangeRefreshToken($config['refresh_token']);
    echo "Successfully obtained access token\n";
    
    // Initialize the SDK
    $sdk = SellingPartnerSDK::create(
        $client,
        $factory, // Pass the RequestFactoryInterface directly
        $factory, // Pass the StreamFactoryInterface directly
        $configuration,
        $logger
    );
    
    echo "SDK initialized successfully\n";
    
    // Create the product listing
    $body = new ListingsItemPutRequest([ 
        'product_type' => 'LUGGAGE', 
        'requirements' => 'LISTING', 
        'attributes' => [ 
            'item_name' => [['value' => 'The North Face Women Recon Backpack']], 
            'brand' => [['value' => 'The North Face']], 
            'color' => [['value' => 'Pamplona Purple/Bonnie Blue']], 
            'material' => [['value' => 'Polycarbonate']], 
            'size' => [['value' => 'One Size']], 
            'list_price' => [[ 
                'currency' => 'USD', 
                'value' => 740.90 
            ]], 
            'external_product_id' => [['value' => '885909950805']], 
            'external_product_id_type' => [['value' => 'UPC']], 
            'country_of_origin' => [['value' => 'US']], 
            'condition_type' => [['value' => 'new']], 
            'item_dimensions' => [[ 
                'height' => ['value' => 13.8, 'unit' => 'inches'], 
                'length' => ['value' => 8.3, 'unit' => 'inches'], 
                'width' => ['value' => 22.1, 'unit' => 'inches'], 
                'weight' => ['value' => 2.5, 'unit' => 'pounds'] 
            ]] 
        ] 
    ]); 

    $sku = 'NF00CLG3ENQ'; 
    $merchant_id = 'A2HDH9PWY7LP2W'; // Replace with your Merchant ID
    $marketplace_id = 'ATVPDKIKX0DER'; // US marketplace ID

    $result = $sdk->listingsItems()->putListingsItem( 
        $accessToken, 
        'us-east-1', 
        $merchant_id, 
        $sku, 
        [$marketplace_id], 
        $body, 
        null 
    ); 

    echo "Listing created successfully:\n"; 
    print_r($result); 
    
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}